# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MonitorSecurityAwakeModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'monitor security awake'

   def __init__( self ):
      self.modeKey = "mon-sec-awake"
      self.longModeKey = "monitor-security-awake"
      CliMode.ConfigMode.__init__( self, None )

   def instanceRuleKey( self ):
      return self.longModeKey

class NdrModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'ndr application'

   def __init__( self ):
      self.modeKey = 'mon-sec-awake-ndr'
      self.longModeKey = 'monitor-security-awake-ndr'
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=MonitorSecurityAwakeModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey

class NucleusModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'nucleus %s' % self.nucleus

   def __init__( self, param ):
      self.nucleus = param
      self.modeKey = 'mon-sec-awake-nucleus'
      self.longModeKey = 'monitor-security-awake-nucleus-%s' % (
                                   self.nucleus )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=MonitorSecurityAwakeModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey
