#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

# The model used to enable the gnsi mode
# The mode can be enabled by the command "management api gnsi" in the config mode
class MgmtGnsiMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api gnsi'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'mgmt-{param}'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return f'mgmt-{cls.__name__}'

# The model used to additional acctz configuration
# The mode can be enabled by the command "service acctz" from "management api gnsi"
class MgmtGnsiAcctzMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'service acctz'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'mgmt-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnsiMode )

   def commentKey( self ):
      return self.longModeKey
