# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MonitorHadoopMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "monitor hadoop"

   def __init__( self, param ):
      self.modeKey = "monitor-hadoop"
      self.longModeKey = "monitor-hadoop"
      CliMode.ConfigMode.__init__( self, param )

class MonitorHadoopClusterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "cluster %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "monitor-hadoop-cluster"
      self.longModeKey = "monitor-hadoop-%s" % param
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
