#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.RouterGeneral import (
      RouterGeneralBaseMode,
      RouterGeneralVrfBaseMode )
import CliMode

class IcmpErrExtBaseMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = 'router-general-icmp-err-ext'
      self.longModeKey = 'router-general-icmp-error-extensions'
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterGeneralBaseMode )

   def enterCmd( self ):
      return 'icmp error extensions'

class IcmpErrExtVrfBaseMode( CliMode.ConfigMode ):
   def __init__( self, vrfName ):
      self.vrfName = vrfName
      self.modeKey = 'router-general-vrf-icmp-err-ext'
      self.longModeKey = f'router-general-vrf-{vrfName}-icmp-error-extensions'
      CliMode.ConfigMode.__init__( self, vrfName,
                                   parentMode=RouterGeneralVrfBaseMode )

   def enterCmd( self ):
      return 'icmp error extensions'

   def skipIfEmpty( self ):
      return True
