#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class IgmpProfileMode( CliMode.ConfigMode ):
   
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'ip igmp profile %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "igmp-profile"
      self.action = "deny"
      self.param_ = param
      self.longModeKey = None
      self.setLongModeKey()
      CliMode.ConfigMode.__init__( self, param )
   
   def setLongModeKey( self ):
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "igmp-profile-%s-%s" % ( self.param_,
                                                  self.action )

