# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingIgmpMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router igmp'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-igmp'
      CliMode.ConfigMode.__init__( self, param )

class RoutingIgmpVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'router-igmp-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIgmpMode )
