#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class InfluxTelemetryBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'monitor telemetry influx'

   def __init__( self ):
      self.modeKey = 'monitor-telemetry-influx'
      self.longModeKey = 'monitor-telemetry-influx'
      CliMode.ConfigMode.__init__( self, None )

   def skipIfEmpty( self ):
      return True

class DestinationInfluxdbMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'destination influxdb {self.param_}'

   def __init__( self, param ):
      self.modeKey = f'destination-influxdb-{param}'
      self.longModeKey = f'destination-influxdb-{param}'
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=InfluxTelemetryBaseMode )

class SourceSocketMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'source socket {self.param_}'

   def __init__( self, param ):
      self.modeKey = f'source-socket-{param}'
      self.longModeKey = f'source-socket-{param}'
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=InfluxTelemetryBaseMode )
