# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class IntfGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'group interface %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'group-if'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'group-if-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class IntfBuiltinGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'group interface %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'builtin-group-if'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'builtin-group-if-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      # CliSave modes do not distinguish between built-in and non built-in modes
      return f'group-if-{self.param_}'

