#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class IntfMaintenanceMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'interface %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param, shortName ):
      self.modeKey = 'maint-if'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'maint-if-%s' % shortName
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
