# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class InterfaceDefaultsSlotTypeMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'slot-type %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'slot-type'
      # (config-osfp-400)# etc.
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'slot-type-%s' % param

      CliMode.ConfigMode.__init__( self, param )

class InterfaceDefaultsModuleMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'module %s' % self.param_[ 1 ] # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'slot-type-module'
      # (config-osfp-400-module-Linecard1)# etc.
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'slot-type-%s-module-%s' % param

      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=InterfaceDefaultsSlotTypeMode )

