# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Arnet import IntfId
import BasicCli
import CliMode
from Vlan import vlanSetToCanonicalString

class AddressLockingBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "address locking"

   def __init__( self ):
      self.modeKey = "address-locking"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

class AddressLockingMode( AddressLockingBaseMode, BasicCli.ConfigModeBase ):
   name = "Address Locking"

   def __init__( self, parent, session ):
      AddressLockingBaseMode.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class InterfaceAddressLockingBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "address locking"

   def __init__( self, param ):
      self.intf = param
      self.cliConfig = None
      self.modeKey = "if-address-locking"
      self.longModeKey = f"if-{IntfId( param ).shortName}-address-locking"
      CliMode.ConfigMode.__init__( self, param )

   def newConfig( self ):
      return self.cliConfig.newInterface( self.intf )

   def getConfig( self ):
      return self.cliConfig.interface.get( self.intf )

class IpLockingEthIntfAddressLockingMode( InterfaceAddressLockingBaseMode,
                                          BasicCli.ConfigModeBase ):
   name = "Ethernet Interface Address Locking Commands"

   def __init__( self, parent, session, param, cliConfig ):
      assert cliConfig
      InterfaceAddressLockingBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
      self.cliConfig = cliConfig

class IpLockingLagIntfAddressLockingMode( InterfaceAddressLockingBaseMode,
                                          BasicCli.ConfigModeBase ):
   name = "LAG Interface Address Locking Commands"

   def __init__( self, parent, session, param, cliConfig ):
      assert cliConfig
      InterfaceAddressLockingBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
      self.cliConfig = cliConfig

class VlanAddressLockingBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "address locking"

   def __init__( self, vlanString ):
      self.vlanString = vlanString
      self.modeKey = "vlan-addr-lock"
      self.longModeKey = f"vlan-{vlanString}-addr-lock"
      CliMode.ConfigMode.__init__( self, vlanString )

# ------------------------------------------------------
# Address locking sub-mode within the "config-vlan" mode.
# ------------------------------------------------------
class IpLockingVlanAddressLockingMode( VlanAddressLockingBaseMode,
                                       BasicCli.ConfigModeBase ):
   name = "Vlan Address Locking Commands"

   def __init__( self, parent, session ):
      self.vlan = parent.vlan
      self.multiInstance = parent.multiInstance
      vlanSet = set()
      if self.multiInstance:
         for m in self.vlan.individualVlans_:
            vlanSet.add( m.vlan.id )
      else:
         vlanSet.add( self.vlan.id )
      vlanString = vlanSetToCanonicalString( vlanSet )
      VlanAddressLockingBaseMode.__init__( self, vlanString )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
