# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

# pylint: disable-msg=C0209

class IkePolicyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"ike policy {self.param_}"

   def __init__( self, param ):
      self.modeKey = "ike"
      self.longModeKey = "ipsec-ike"
      CliMode.ConfigMode.__init__( self, param )

class SecurityAssociationMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"sa policy {self.param_}"

   def __init__( self, param ):
      self.modeKey = "sa"
      self.longModeKey = "ipsec-sa"
      CliMode.ConfigMode.__init__( self, param )

class SecurityAssociationVxlanMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"sa policy vxlan security {self.param_}"

   def __init__( self, param ):
      self.modeKey = "sa"
      self.longModeKey = "ipsec-sa"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return "ipsec-vxlan-sa"

class IpSecurityMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "ip security"

   def __init__( self ):
      self.modeKey = "ipsec"
      self.longModeKey = "ipsec"
      CliMode.ConfigMode.__init__( self, 1 )

class IpsecProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"profile {self.profileName}"

   def __init__( self, param ):
      self.profileName = param
      self.modeKey = "ipsec"
      self.longModeKey = "ipsec-profile"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return f"{self.longModeKey }-{self.param_}"

class IpsecEntropyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"flow entropy {self.protoName}"

   def __init__( self, param ):
      self.profileName, self.protoName = param
      self.modeKey = "entropy"
      self.longModeKey = "ipsec-entropy"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return f"{self.profileName}-{self.longModeKey }-{self.protoName}"

class KeyControllerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "key controller"

   def __init__( self ):
      self.modeKey = "key-controller"
      self.longModeKey = "ipsec-key-controller"
      CliMode.ConfigMode.__init__( self, 1 )

class IpsecIkeCryptoSuiteCliMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"crypto ike-suite {self.param_}"

   def __init__( self, param ):
      self.modeKey = "crypto"
      self.longModeKey = "ipsec-crypto-ike-%s" % param
      CliMode.ConfigMode.__init__( self, param )

class IpsecSaCryptoSuiteCliMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"crypto sa-suite {self.param_}"

   def __init__( self, param ):
      self.modeKey = "crypto"
      self.longModeKey = "ipsec-crypto-sa-%s" % param
      CliMode.ConfigMode.__init__( self, param )
