# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Ira import RouterKernelMode

class RouterKernelAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'address-family {self.addrFamily}'

   def __init__( self, param ):
      self.vrfName, self.addrFamily = param
      self.modeKey = 'router'
      self.longModeKey = f'router-kernel-vrf-{self.vrfName}-af-{self.addrFamily}'
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterKernelMode )


