#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

# Cli config mode for "monitor system"
class MonitorSystemMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'monitor system'

   def __init__( self, param ):
      self.modeKey = "monitor-system"
      self.longModeKey = "monitor-system"
      CliMode.ConfigMode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

# Cli config mode for "memory exhaustion"
class MemoryExhaustionMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'memory exhaustion'

   def __init__( self, param ):
      self.modeKey = "monitor-system-memory"
      self.longModeKey = "monitor-system-memory"
      CliMode.ConfigMode.__init__( self, param )

   def skipIfEmpty( self ):
      return True
