#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class LauncherDaemonMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'daemon %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "daemon"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "daemon-%s" % param
      CliMode.ConfigMode.__init__( self, param )



