# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class LineSystemMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "line system"

   def __init__( self, param ):
      self.modeKey = "ls"
      self.longModeKey = "ls"
      CliMode.ConfigMode.__init__( self, param )

class PortRangeMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "port %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "ls-port"
      self.longModeKey = "ls-%s" % param
      CliMode.ConfigMode.__init__( self, param )
