# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MacsecBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'mac security'

   def __init__( self, param ):
      self.modeKey = "mac-security"
      self.longModeKey = "mac-security"
      CliMode.ConfigMode.__init__( self, param )

class MacsecProfileBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'profile %s' % self.profileName

   def __init__( self, param ):
      self.modeKey = "profile"
      self.profileName = param
      self.longModeKey = "mac-security-profile-%s" % self.profileName

      CliMode.ConfigMode.__init__( self, param )

class MacsecProfileStaticSakMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'key source sak static'

   def __init__( self, param ):
      self.modeKey = 'sak-static'
      self.profileName = param
      self.longModeKey = "mac-security-profile-%s-sak-static" % self.profileName
      
      CliMode.ConfigMode.__init__( self, param )

class MacsecProfileSecureChannelMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'secure channel %s' % self.txOrRx

   def __init__( self, param ):
      self.modeKey = "secure-channel"
      self.profileName = param[ 0 ]
      self.txOrRx = param[ 1 ]
      self.longModeKey = "mac-security-profile-%s-sak-static-sc-%s" \
            % ( self.profileName, self.txOrRx )

      CliMode.ConfigMode.__init__( self, param )
