# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class MaintenanceUnitMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'unit %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'unit'
      self.longModeKey = 'unit-%s' % param # pylint: disable=consider-using-f-string
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
