# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MatchListMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'match-list input %s %s' % ( self.inputType_, self.param_ )

   def __init__( self, param, inputType ):
      self.inputType_ = inputType
      # pylint: disable-next=consider-using-f-string
      self.modeKey = "match-list-%s" % inputType
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "match-list-%s-%s" % ( inputType, param )
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
