# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtGnmiClientBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management client api gnmi'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'mgmt-{param}'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return f'mgmt-{cls.__name__}'

class GnmiServerBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'server {self.gnmiServerName}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.gnmiServerName = param
      self.longModeKey = f'gnmi-server-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnmiClientBaseMode )

class GnmiServerGroupBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'group {self.gnmiServerGroupName}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.gnmiServerGroupName = param
      self.longModeKey = f'gnmi-sg-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnmiClientBaseMode )
