#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import BasicCli
from TypeFuture import TacLazyType

TunnelMode = TacLazyType( "Mirroring::TunnelMode" )

class NamedDestConfigModeBase( CliMode.ConfigMode ):

   def __init__( self, param ):
      ( self.parentMode, self.destName ) = param
      self.modeKey = 'mon-dest'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'mon-dest-%s' % self.destName
      CliMode.ConfigMode.__init__( self, param, parentMode=self.parentMode )

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'monitor session destination %s' % self.destName

class NamedDestConfigMode( NamedDestConfigModeBase, BasicCli.ConfigModeBase ):
   name = "mirror destination name"

   def __init__( self, parent, session, context ):
      self.context = context
      param = ( parent, self.context.destName )
      NamedDestConfigModeBase.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class NamedDestTunnelConfigModeBase( CliMode.ConfigMode ):
   tunnelMap = { TunnelMode.tunnelVxlan : 'vxlan' }

   def __init__( self, param ):
      ( parent, self.destName, self.tunnelType ) = param
      self.modeKey = 'mon-dest'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'mon-dest-%s-%s' % (
         self.tunnelMap[ self.tunnelType ], self.destName )
      CliMode.ConfigMode.__init__( self, param, parentMode=parent )

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'tunnel mode %s' % self.tunnelMap[ self.tunnelType ]

class NamedDestVxlanTunnelConfigMode( NamedDestTunnelConfigModeBase,
                                      BasicCli.ConfigModeBase ):

   def __init__( self, parent, session, context, tunnelType ):
      self.context = context
      param = ( parent, self.context.destName, tunnelType )
      NamedDestTunnelConfigModeBase.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

