# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtModelsMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api models'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-api-models'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class ProviderAFTMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider aft'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-aft'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderSmashMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider smash'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-smash'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderSysdbMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider sysdb'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-sysdb'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderIPFIXMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider ipfix'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-ipfix'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderSflowMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider sflow'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-sflow'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderHttpCommandsMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider http-commands'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-http-commands'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderIsisMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider isis'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-isis'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderOspfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider ospf'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-ospf'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderBgpMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider bgp'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-bgp'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderBgpRibMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'bgp-rib'

   def __init__( self, param ):
      self.modeKey = 'bgp-rib'
      self.longModeKey = 'bgp-rib'
      CliMode.ConfigMode.__init__( self, param, parentMode=ProviderBgpMode )

class ProviderMacsecMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider macsec'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-macsec'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ProviderConfigurationMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider configuration'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-configuration'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ModelsMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'models'

   def __init__( self, param ):
      self.modeKey = 'models'
      self.longModeKey = 'models'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

class ModulesMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'modules'

   def __init__( self, param ):
      self.modeKey = 'modules'
      self.longModeKey = 'modules'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )
