#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode

class StaticMulticastModeBase( CliMode.ConfigMode ):

   def __init__( self, inLabel ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-mcast-route-%s' % inLabel
      self.inLabel = inLabel
      CliMode.ConfigMode.__init__( self, inLabel )

   def enterCmd( self ):
      return "mpls static multicast top-label %s" % self.inLabel

class TunnelStaticModeBase( CliMode.ConfigMode ):

   def __init__( self, tunName, tep ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-tunnel-%s' % tunName
      self.tunName = tunName
      self.tep = tep
      CliMode.ConfigMode.__init__( self, tunName )

   def enterCmd( self ):
      return "mpls tunnel static %s %s" % ( self.tunName, self.tep )

class TunnelTerminationModeBase( CliMode.ConfigMode ):

   def __init__( self ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-tunnel-termination'
      CliMode.ConfigMode.__init__( self, self.longModeKey )

   def enterCmd( self ):
      return 'mpls tunnel termination'

class TunnelTerminationVrfModeBase( CliMode.ConfigMode ):

   def __init__( self, vrfName ):
      self.vrfName = vrfName
      self.modeKey = 'vrf-%s' % ( self.vrfName )
      self.longModeKey = 'mpls-tunnel-termination-vrf-%s' % ( self.vrfName )
      CliMode.ConfigMode.__init__( self, vrfName,
                                   parentMode=TunnelTerminationModeBase )

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

class LfibStitchingPreferencesModeBase( CliMode.ConfigMode ):

   def __init__( self ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-lfib-preferences'
      CliMode.ConfigMode.__init__( self, self.longModeKey )

   def enterCmd( self ):
      return 'mpls lfib stitching preferences'
