#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingMsdpBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router msdp'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-msdp'
      CliMode.ConfigMode.__init__( self, param )

class RoutingMsdpVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'router-msdp-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingMsdpBaseMode )

class RoutingMsdpPeerMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'peer ' + str( self.peer )

   def __init__( self, vrfName, peer ):
      self.modeKey = 'router'
      self.peer = peer
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         # pylint: disable-next=consider-using-f-string
         self.longModeKey = 'router-msdp-peer-%s' % peer
      else:
         self.longModeKey = f'router-msdp-vrf-{vrfName}-peer-{peer}'
      CliMode.ConfigMode.__init__( self, ( vrfName, peer ) )
