#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import CliMode

class P4RuntimeMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'p4-runtime'

   def __init__( self, param ):
      self.modeKey = "p4-runtime"
      self.longModeKey = "p4-runtime"
      CliMode.ConfigMode.__init__( self, param )

class P4RuntimeTransportMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = "p4-runtime-transport"
      self.longModeKey = "p4-runtime-transport-{}".format( param )
      CliMode.ConfigMode.__init__( self, param, parentMode=P4RuntimeMode )

   def enterCmd( self ):
      return 'transport grpc %s' % self.param_
