# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
from CliMode.Mgmt import ManagementMode

class PasswordPolicyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'password policy %s' % self.param_

   def __init__( self, param ):
      tmp = param.split()[ 0 ]
      self.modeKey = 'pwd-policy'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'pwd-policy-%s' % tmp
      CliMode.ConfigMode.__init__( self, param, parentMode=ManagementMode )
