#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingPimMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router pim'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-pim'
      CliMode.ConfigMode.__init__( self, param )

class RoutingPimVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingPimMode )

class RoutingPimAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-pim-%s' % af
      else:
         self.longModeKey = f'router-pim-vrf-{vrfName}-{af}'
      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )

class RoutingPimSparseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router pim sparse-mode'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-sparse'
      CliMode.ConfigMode.__init__( self, param )

class RoutingPimSparseVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-sparse-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingPimSparseMode )

class RoutingPimSparseAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-pim-sparse-%s' % af
      else:
         self.longModeKey = f'router-pim-sparse-vrf-{vrfName}-{af}'
      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )
