#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingPimBsrMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router pim bsr'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-bsr'
      CliMode.ConfigMode.__init__( self, param )

class RoutingPimBsrVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'router-pim-bsr-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingPimBsrMode )

class RoutingPimBsrAfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         # pylint: disable-next=consider-using-f-string
         self.longModeKey = 'router-pim-bsr-%s' % af
      else:
         self.longModeKey = f'router-pim-bsr-vrf-{vrfName}-{af}'
      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )
