#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class PoeMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'poe'

   def __init__( self ):
      self.modeKey = 'poe'
      self.longModeKey = 'poe'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class PoeLinecardMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'module Linecard%s' % ( self.number )

   def __init__( self, param ):
      self.number = str( param )
      self.modeKey = 'poe-linecard'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'poe-linecard%s' % ( self.number )

      CliMode.ConfigMode.__init__( self, param, parentMode=PoeMode )
