#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Tracing
import CliMode
from CliMode.SamplePolicy import ( SamplePolicyConfigMode,
                                   SamplePolicyMatchRuleConfigMode,
                                   SamplePolicyActionRuleConfigMode )

__defaultTraceHandle__ = Tracing.Handle( 'PostcardTelemetry' )
t0 = __defaultTraceHandle__.trace0

FEATURE = 'postcard-sample-policy'
class PostcardTelemetryModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "monitor telemetry postcard policy"

   def __init__( self ):
      self.modeKey = "tele-postcard-policy"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

class PostcardPolicyConfigMode( PostcardTelemetryModeBase, BasicCli.ConfigModeBase ):
   name = "mon-telemetry-postcard"

   def __init__( self, parent, session, context ):
      self.telemetryContext = context
      PostcardTelemetryModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def onExit( self ):
      self.commitContext()
      BasicCli.ConfigModeBase.onExit( self )

   def abort( self ):
      self.telemetryContext = None
      self.session_.gotoParentMode()

   def commitContext( self ):
      t0( 'Commit telemetry postcard' )
      context = self.telemetryContext
      if context:
         context.commit()
         self.telemetryContext = None

   def commit( self ):
      self.commitContext()
      self.session_.gotoParentMode()

class ProfileModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "profile %s" % self.profileName

   def __init__( self, param ):
      if isinstance( param, list ):
         self.profileName = param[ 0 ]
      else:
         self.profileName = param
      self.modeKey = "postcard-profile-%s" % self.profileName
      self.longModeKey = "postcard-profile-%s" % self.profileName
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=PostcardPolicyConfigMode )

class ProfileConfigMode( ProfileModeBase, BasicCli.ConfigModeBase ):
   name = "port profile configuration"

   def __init__( self, parent, session, context ):
      self.profileContext = context
      param = ( context.profileName_ )
      ProfileModeBase.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def onExit( self ):
      t0( 'Exit profile %s' % self.profileName )
      self.commitContext()
      BasicCli.ConfigModeBase.onExit( self )

   def abort( self ):
      self.profileContext = None
      self.session_.gotoParentMode()

   def commitContext( self ):
      t0( 'Commit port profile' )
      context = self.profileContext
      if context and self.profileName != 'default':
         context.commit()
         self.profileContext = None

   def commit( self ):
      self.commitContext()
      self.session_.gotoParentMode()

# Configuration mode for sample-policy
class PostcardSamplePolicyConfigMode( SamplePolicyConfigMode ):
   name = "Postcard sample-policy configuration"

# Match rule configuration mode
class PostcardSamplePolicyMatchRuleIpv4ConfigMode( SamplePolicyMatchRuleConfigMode ):
   name = 'Postcard sample-policy match rule ipv4 configuration'

# Match rule configuration mode
class PostcardSamplePolicyMatchRuleIpv6ConfigMode( SamplePolicyMatchRuleConfigMode ):
   name = 'Postcard sample-policy match rule ipv6 configuration'

# Action configuration mode
class PostcardSamplePolicyActionRuleConfigMode( SamplePolicyActionRuleConfigMode ):
   name = 'Postcard sample-policy action rule configuration'
