#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class RadiusServerGroupMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'aaa group server radius %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "sg-radius"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "sg-radius-%s" % param
      CliMode.ConfigMode.__init__( self, param )
