#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class RadiusProxyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'radius proxy'

   def __init__( self, param ):
      self.modeKey = 'radius-proxy'
      self.longModeKey = 'radius-proxy'
      CliMode.ConfigMode.__init__( self, param )

class RadiusProxyClientGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f'client group { self.param_ }'

   def __init__( self, param ):
      self.modeKey = 'rp-cg'
      self.longModeKey = f'rp-cg-{ param }'
      self.groupName = param
      CliMode.ConfigMode.__init__( self, param, parentMode=RadiusProxyMode )
