#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import re

import CliMode

def generateCommentKey( routeMapName, permitDeny, seqno ):
   ''' Single source to generate key string from these args '''
   return 'route-map-%s-%s-%s' % \
         ( re.escape( routeMapName ), permitDeny, seqno )

class RouteMapCliMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "route-map %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "route-map"
      tmp = param.split()[0]
      self.longModeKey = "route-map-%s" % tmp
      CliMode.ConfigMode.__init__( self, param )

class PeerFilterCliMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "peer-filter %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "peer-filter"
      tmp = param.split()[0]
      self.longModeKey = "peer-filter-%s" % tmp
      CliMode.ConfigMode.__init__( self, param )

class IpPrefixListCliMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "ip prefix-list %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "ip-prefix-list"
      self.longModeKey = f"ip-pfx-{param}"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return "ip-pfx-%s" % self.param_

class Ipv6PrefixListCliMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "ipv6 prefix-list %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "ipv6-prefix-list"
      self.longModeKey = f"ipv6-pfx-{param}"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return "ipv6-pfx-%s" % self.param_
