# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode

class MonitorServerBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'monitor server %s' % self.protocol

   def __init__( self, param ):
      self.modeKey = "monitor"
      self.protocol = param
      self.longModeKey = "monitor-server-%s" % self.protocol
      CliMode.ConfigMode.__init__( self, param )
