# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import BasicCli

class RouterInternetExitModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'router internet-exit'

   def __init__( self ):
      self.modeKey = 'ie'
      self.longModeKey = 'internet-exit'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class RouterInternetExitConfigMode( RouterInternetExitModeBase,
                                    BasicCli.ConfigModeBase ):
   ''' Configuration mode for router internet-exit '''
   name = 'router internet-exit'

   def __init__( self, parent, session ):
      RouterInternetExitModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterIeExitGroupModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      exitGroupStr = f'exit-group {self.exitGroupName}'
      return exitGroupStr

   def __init__( self, exitGroupName ):
      self.exitGroupName = exitGroupName
      self.modeKey = 'exit-group'
      self.longModeKey = f'exit-group-{self.exitGroupName}'
      CliMode.ConfigMode.__init__( self, exitGroupName,
                                   parentMode=RouterInternetExitConfigMode )

class RouterIeExitGroupConfigMode( RouterIeExitGroupModeBase,
                                  BasicCli.ConfigModeBase ):
   ''' Configuration mode for exit-group under router internet-exit mode '''
   name = 'exit-group configuration'

   def __init__( self, parent, session, context ):
      self.context = context
      RouterIeExitGroupModeBase.__init__( self, context.exitGroupName() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterIePolicyModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      policyStr = f'policy {self.policyName}'
      return policyStr

   def __init__( self, policyName ):
      self.policyName = policyName
      self.modeKey = 'policy'
      self.longModeKey = f'policy-{self.policyName}'
      CliMode.ConfigMode.__init__( self, policyName,
                                   parentMode=RouterInternetExitConfigMode )

class RouterIePolicyConfigMode( RouterIePolicyModeBase,
                                BasicCli.ConfigModeBase ):
   ''' Configuration mode for policy under router internet-exit mode '''
   name = 'policy configuration'

   def __init__( self, parent, session, context ):
      self.context = context
      RouterIePolicyModeBase.__init__( self, context.policyName() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
