# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import BasicCli

class RouterServiceInsertionModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'router service-insertion'

   def __init__( self ):
      self.modeKey = 'si'
      self.longModeKey = 'service-insertion'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class RouterServiceInsertionConfigMode( RouterServiceInsertionModeBase,
                                        BasicCli.ConfigModeBase ):
   ''' Configuration mode for router service-insertion '''
   name = 'router service-insertion'

   def __init__( self, parent, session ):
      RouterServiceInsertionModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterSiConnectionModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      connectionStr = f'connection {self.connectionName}'
      return connectionStr

   def __init__( self, connectionName ):
      self.connectionName = connectionName
      self.modeKey = 'connection'
      self.longModeKey = f'connection-{self.connectionName}'
      CliMode.ConfigMode.__init__( self, connectionName,
                                   parentMode=RouterServiceInsertionConfigMode )

class RouterSiConnectionConfigMode( RouterSiConnectionModeBase,
                                    BasicCli.ConfigModeBase ):
   ''' Configuration mode for connection under router service-insertion mode '''
   name = 'connection configuration'

   def __init__( self, parent, session, context ):
      self.context = context
      RouterSiConnectionModeBase.__init__( self, context.connectionName() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterSiServiceGroupModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      serviceGroupStr = f'service group {self.groupName} id {self.groupId}'
      return serviceGroupStr

   def __init__( self, groupName, groupId ):
      self.groupName = groupName
      self.groupId = groupId
      self.modeKey = 'service-group'
      self.longModeKey = f'service-group-{self.groupName}'
      CliMode.ConfigMode.__init__( self, groupName,
                                   parentMode=RouterServiceInsertionConfigMode )

class RouterSiServiceGroupConfigMode( RouterSiServiceGroupModeBase,
                                      BasicCli.ConfigModeBase ):
   ''' Configuration mode for service group under router service-insertion mode '''
   name = 'service group configuration'

   def __init__( self, parent, session, context ):
      self.context = context
      RouterSiServiceGroupModeBase.__init__( self, context.groupName(),
                                             context.groupId() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterSiServiceGroupInstanceModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      instanceStr = f'instance {self.instanceName} id {self.instanceId}'
      return instanceStr

   def __init__( self, groupName, instanceName, instanceId ):
      self.groupName = groupName
      self.instanceName = instanceName
      self.instanceId = instanceId
      self.modeKey = 'service-group-instance'
      self.longModeKey = f'sg-{self.groupName}-instance-{self.instanceName}'
      CliMode.ConfigMode.__init__( self, groupName,
                                   parentMode=RouterSiServiceGroupModeBase )

class RouterSiServiceGroupInstanceConfigMode( RouterSiServiceGroupInstanceModeBase,
                                      BasicCli.ConfigModeBase ):
   ''' Configuration mode for instance under service group '''
   name = 'service group instance configuration'

   def __init__( self, parent, session, context ):
      self.context = context
      RouterSiServiceGroupInstanceModeBase.__init__( self, context.groupName(),
            context.instanceName(), context.instanceId() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
