# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SnmpOverrideMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'snmp-server objects override'

   def skipIfEmpty( self ):
      return True

   def __init__( self, param ):
      self.modeKey = 'snmp-override'
      self.longModeKey = 'snmp-override'
      CliMode.ConfigMode.__init__( self, param )

class SnmpOverrideContextMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'context %s' % ( self.param_ ) # pylint: disable=consider-using-f-string

   def skipIfEmpty( self ):
      return True

   def __init__( self, param ):
      self.modeKey = 'snmp-override-ctx'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'snmp-override-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=SnmpOverrideMode )
