# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SshTunnelMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "tunnel %s" % self.tunnelName # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.tunnelName = param
      self.modeKey = "mgmt-ssh-tunnel"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "mgmt-ssh-tunnel-%s" % param
      CliMode.ConfigMode.__init__( self, self.longModeKey, 
                                   parentMode=CliMode.ConfigMode )

class SshTunnelVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "tunnel %s" % self.tunnelName  # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      ( self.parentVrf, self.tunnelName ) = param
      self.modeKey = "mgmt-ssh-vrf-ssh-tunnel"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "mgmt-ssh-vrf-%s-tunnel-%s" % param
      CliMode.ConfigMode.__init__( self, self.longModeKey, 
                                   parentMode=CliMode.ConfigMode )
