# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode

class SslProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'ssl profile %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "mgmt-sec-ssl-profile"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "mgmt-sec-ssl-profile-%s" % param
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=CliMode.Mgmt.ManagementMode )

