# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import (
   absolute_import,
   division,
   print_function,
)

from BasicCli import ConfigModeBase
from CliParser import ModeParseTree
from TypeFuture import TacLazyType

from CliMode import ConfigMode
from CliMode.Intf import IntfMode

synceModeStr = 'sync-e'

class SynceMode( ConfigMode ):
   def __init__( self ):
      self.modeKey = synceModeStr
      self.longModeKey = self.modeKey
      ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return synceModeStr

class SynceIntfMode( ConfigMode ):
   def __init__( self, intfName ):
      self.modeKey = synceModeStr
      intfShortName = TacLazyType( 'Arnet::IntfId' )( intfName ).shortName
      self.longModeKey = 'if-{}-{}'.format( intfShortName, self.modeKey )
      ConfigMode.__init__( self, None, parentMode=IntfMode )

   def enterCmd( self ):
      return synceModeStr

# sync-e [ instance NAME ]
class SynceConfigMode( SynceMode, ConfigModeBase ):
   modeParseTree = ModeParseTree()

   def __init__( self, parent, session ):
      SynceMode.__init__( self )
      ConfigModeBase.__init__( self, parent, session )

# interface EthernetXX
#    sync-e [ instance NAME ]
class SynceIntfConfigMode( SynceIntfMode, ConfigModeBase ):
   modeParseTree = ModeParseTree()

   def __init__( self, parent, session, intf ):
      SynceIntfMode.__init__( self, intf )
      ConfigModeBase.__init__( self, parent, session )
      self.intf = intf
