# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the base CLI mode for all system-wide L1 configurations.'''

import CliMode

class SystemL1Mode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'system l1'

   def __init__( self ):
      self.modeKey = 'system-l1'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, self.modeKey )
