#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class TechSupportPolicyMode( CliMode.ConfigMode ):
   '''
   A mode to configure tech-support policies. This mode is a child of
   "management tech-support" mode and can be entered with:
      From global config mode:
         management tech-support
            policy < NAME >
            (e.g. policy show tech-support)
   '''

   def enterCmd( self ):
      return 'policy %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "tech-spt-policy"
      if param == 'show tech-support':
         self.longModeKey = self.modeKey + '-show-tech'
      else:
         self.longModeKey = self.modeKey + '-' + param
      CliMode.ConfigMode.__init__( self, param )
