#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class VlanMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # vlanString is used in this function, for output, while vlanStart
      # is not used. vlanStart is part of the param, to ensure that
      # the vlans are sorted numerically.
      vlanStart, vlanString, enabled = self.param_
      if enabled:
         return 'vlan %s' % vlanString # pylint: disable=consider-using-f-string
      else:
         # Only vlan 1 is created by default and so needs to generate a
         # 'no vlan 1' command when it is deleted by the user.
         assert ( ( vlanString == '1' ) and ( vlanStart == 1 ) )
         return 'no vlan 1'

   def __init__( self, param ):
      self.modeKey = "vlan"
      _, vlanString, _ = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "vlan-%s" % vlanString
      CliMode.ConfigMode.__init__( self, param )
