#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class VrfConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      # param should be a tuple ( vrfName, service, config )
      # service should be the name of the service
      # config should be the mgmt config mount
      ( self.vrfName_, service, self.config_ ) = param
      # pylint: disable-next=consider-using-f-string
      self.modeKey = 'mgmt-%s-vrf' % ( service, )
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'mgmt-%s-vrf-%s' % ( service, self.vrfName_ )
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
      self.config()

   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

   def shutdown( self ):
      self.config().serverState = "disabled"

   def noShutdown( self ):
      self.config().serverState = "enabled"

   def defaultShutdown( self ):
      self.config().serverState = "globalDefault"

class NameServerGroupMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'ip name-server group %s' % self.groupName_

   def __init__( self, param ):
      self.groupName_ = param
      self.modeKey = "ns"
      self.longModeKey = "ns-%s" % param # pylint: disable=consider-using-f-string
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
