# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class VxlanMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'service vxlan'

   def __init__( self, param ):
      self.modeKey = 'cvx-vxlan'
      if param:
         # pylint: disable-next=consider-using-f-string
         self.longModeKey = 'cvx-vxlan-%s' % param
      else:
         self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )
