# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand
import TimeRangeRule

from CliPlugin import AaaCli
from CliPlugin import AaaModel
import AaaDefs

aaaKwMatcher = CliMatcher.KeywordMatcher( 'aaa', helpdesc='Show AAA values' )
methodsKwMatcher = CliMatcher.KeywordMatcher( 'methods',
                                              helpdesc='Show AAA method lists' )
methodListsKwMatcher = CliMatcher.KeywordMatcher( 'method-lists',
                                              helpdesc='Show AAA method lists' )
methodListNode = CliCommand.Node( matcher=methodListsKwMatcher,
                                  deprecatedByCmd='show aaa methods' )
usersKwMatcher = CliMatcher.KeywordMatcher( 'users',
                                            helpdesc=AaaCli.showUsersDesc )
# pylint: disable=protected-access
roleNameMatcher = CliMatcher.DynamicNameMatcher(
      lambda mode : AaaCli._getLocalUserConfig( mode ).role, "Role name",
      pattern=AaaDefs.roleNameRe, helpname='WORD' )
# pylint: enable=protected-access

#-----------------------------------------------------------------------------------
# show aaa
#-----------------------------------------------------------------------------------
class ShowAaaCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa'
   data = {
            'aaa': aaaKwMatcher,
          }
   privileged = True
   cliModel = "AaaShowModel.AaaUsers"
   handler = "AaaShowHandler.showAaa"

BasicCli.addShowCommandClass( ShowAaaCmd )

#-----------------------------------------------------------------------------------
# show aaa ( methods | method-lists ) authentication
#-----------------------------------------------------------------------------------
class ShowAaaMethodsAuthen( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa ( methods | method-lists ) authentication'
   data = {
            'aaa': aaaKwMatcher,
            'methods': methodsKwMatcher,
            'method-lists': methodListNode,
            'authentication': 'Show AAA authentication method lists',
          }
   privileged = True
   cliModel = "AaaShowMethodModel.AaaMethodListsAuthen"
   handler = "AaaShowMethodHandler.showAuthenMethodLists"

BasicCli.addShowCommandClass( ShowAaaMethodsAuthen )

#-----------------------------------------------------------------------------------
# show aaa ( methods | method-lists ) authorization
#-----------------------------------------------------------------------------------
class ShowAaaMethodsAuthz( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa ( methods | method-lists ) authorization'
   data = {
            'aaa': aaaKwMatcher,
            'methods': methodsKwMatcher,
            'method-lists': methodListNode,
            'authorization': 'Show AAA authorization method lists',
          }
   privileged = True
   cliModel = "AaaShowMethodModel.AaaMethodListsAuthz"
   handler = "AaaShowMethodHandler.showAuthzMethodLists"

BasicCli.addShowCommandClass( ShowAaaMethodsAuthz )

#-----------------------------------------------------------------------------------
# show aaa ( methods | method-lists ) accounting
#-----------------------------------------------------------------------------------
class ShowAaaMethodsAcct( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa ( methods | method-lists ) accounting'
   data = {
            'aaa': aaaKwMatcher,
            'methods': methodsKwMatcher,
            'method-lists': methodListNode,
            'accounting': 'Show AAA accounting method lists',
          }
   privileged = True
   cliModel = "AaaShowMethodModel.AaaMethodListsAcct"
   handler = "AaaShowMethodHandler.showAcctMethodLists"

BasicCli.addShowCommandClass( ShowAaaMethodsAcct )

#-----------------------------------------------------------------------------------
# show aaa ( methods | method-lists ) all
#-----------------------------------------------------------------------------------
class ShowAaaMethodsAll( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa ( methods | method-lists ) all'
   data = {
            'aaa': aaaKwMatcher,
            'methods': methodsKwMatcher,
            'method-lists': methodListNode,
            'all': 'Show all AAA method lists',
          }
   privileged = True
   cliModel = "AaaShowMethodModel.AaaMethodLists"
   handler = "AaaShowMethodHandler.showAllMethodLists"

BasicCli.addShowCommandClass( ShowAaaMethodsAll )

#-----------------------------------------------------------------------------------
# show aaa sessions
#-----------------------------------------------------------------------------------
class ShowAaaSessionsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa sessions'
   data = {
            'aaa': aaaKwMatcher,
            'sessions': CliCommand.Node(
                           matcher=CliMatcher.KeywordMatcher( 'sessions',
                                           helpdesc='Show authentication sessions' ),
                           deprecatedByCmd='show users detail' )
          }
   cliModel = AaaModel.ShowAaaSessions
   privileged = True
   handler = AaaCli.showSessions

BasicCli.addShowCommandClass( ShowAaaSessionsCmd )

#-----------------------------------------------------------------------------------
# show aaa authentication lockout
#-----------------------------------------------------------------------------------
class ShowAaaAuthenLockoutCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa authentication lockout'
   data = {
            'aaa': aaaKwMatcher,
            'lockout': 'Show locked account information',
            'authentication': 'Show AAA authentication information',
          }
   privileged = True
   cliModel = "AaaShowModel.AaaLockedUsers"
   handler = "AaaShowHandler.showLockout"

BasicCli.addShowCommandClass( ShowAaaAuthenLockoutCmd )

#-----------------------------------------------------------------------------------
# show aaa counters
#-----------------------------------------------------------------------------------
class ShowAaaCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa counters'
   data = {
            'aaa': aaaKwMatcher,
            'counters': 'Show AAA counters',
          }
   cliModel = AaaModel.AaaCounters
   privileged = True
   handler = AaaCli.showCounters

BasicCli.addShowCommandClass( ShowAaaCountersCmd )

#-----------------------------------------------------------------------------------
# show role [ { ROLE } ]
#-----------------------------------------------------------------------------------
class ShowRoleCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show role [ { ROLE } ]'
   data = {
            'role': CliCommand.Node(
                        matcher=CliMatcher.KeywordMatcher( 'role',
                                                      helpdesc='Role information' ),
                        deprecatedByCmd='show users roles' ),
            'ROLE': roleNameMatcher,
          }
   privileged = True
   cliModel = "AaaShowModel.ShowRoles"
   handler = "AaaShowHandler.showRoleByName"

BasicCli.addShowCommandClass( ShowRoleCmd )

#-----------------------------------------------------------------------------------
# show users roles [ { ROLE } ]
#-----------------------------------------------------------------------------------
class ShowUsersRolesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show users roles [ { ROLE } ]'
   data = {
            'users': usersKwMatcher,
            'roles': 'Show user role information',
            'ROLE': roleNameMatcher,
          }
   privileged = True
   cliModel = "AaaShowModel.ShowRoles"
   handler = "AaaShowHandler.showRoleByName"

BasicCli.addShowCommandClass( ShowUsersRolesCmd )

#-----------------------------------------------------------------------------------
# show users
#-----------------------------------------------------------------------------------
class ShowUsersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show users'
   data = {
            'users': usersKwMatcher,
          }
   cliModel = AaaModel.ShowAaaUsers
   privileged = True
   handler = AaaCli.showUsers

BasicCli.addShowCommandClass( ShowUsersCmd )

#-----------------------------------------------------------------------------------
# show users detail
#-----------------------------------------------------------------------------------
class ShowUsersDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show users detail'
   data = {
            'users': usersKwMatcher,
            'detail': 'More comprehensive output',
          }
   cliModel = AaaModel.ShowAaaSessions
   privileged = True
   handler = AaaCli.showSessions

BasicCli.addShowCommandClass( ShowUsersDetailCmd )

#-----------------------------------------------------------------------------------
# show user-account
#-----------------------------------------------------------------------------------
class ShowUserAccountCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show user-account'
   data = {
            'user-account': CliCommand.Node(
                              matcher=CliMatcher.KeywordMatcher( 'user-account',
                                                  helpdesc='Show user information' ),
                              deprecatedByCmd='show users accounts' )
          }
   privileged = True
   cliModel = "AaaShowModel.Users"
   handler = "AaaShowHandler.showUserAccount"

BasicCli.addShowCommandClass( ShowUserAccountCmd )

#-----------------------------------------------------------------------------------
# show users accounts
#-----------------------------------------------------------------------------------
class ShowUsersAccounts( ShowCommand.ShowCliCommandClass ):
   syntax = 'show users accounts'
   data = {
            'users': usersKwMatcher,
            'accounts': 'Show user account information',
          }
   cliModel = "AaaShowModel.Users"
   privileged = True
   handler = "AaaShowHandler.showUserAccount"

BasicCli.addShowCommandClass( ShowUsersAccounts )

#-----------------------------------------------------------------------------------
# show aaa accounting logs
#-----------------------------------------------------------------------------------
class ShowAaaAccounting( ShowCommand.ShowCliCommandClass ):
   syntax = 'show aaa accounting logs [ { ( username USER ) | TIME } ]'
   data = {
      'aaa' : 'Show AAA values',
      'accounting': 'Show AAA accounting information',
      'logs' : 'Show accounting logs',
      'username' : CliCommand.singleKeyword( 'username',
                                    helpdesc='Filter logs by user name' ),
      'USER' : AaaCli.usernameMatcher,
      'TIME' : TimeRangeRule.timeRangeExpression( 'TIME', maxMatches=1 )
   }
   privileged = True
   handler = AaaCli.showAccountLog

BasicCli.addShowCommandClass( ShowAaaAccounting )
