# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import ( DeferredModel, Dict, Int, List, Str, Enum,
                        Submodel, Float )

class BatchStatus ( DeferredModel ):
   updateType = Enum( values=( "noUpdate", "hitless", "hitful", ),
                      help="Update type for this chip's rules" )

class StageInfo( DeferredModel ):
   name = Str( help="Aegis processing stage name" )
   startTime = Float( optional=True,
                      help="UTC epoch timestamp for Aegis \
                      stage start time" )
   endTime = Float( optional=True,
                    help="UTC epoch timestamp for Aegis stage end time" )
   status = Enum( values=( "notStarted", "inProgress", "completed" ),
                  help="Stage update status" )
   errorMessage = Str( optional=True, help="Error messages \
                                            for Aegis stage" )

class ChipInfo( DeferredModel ):
   status = Submodel( valueType=BatchStatus, help="Status of updates" )
   stages = List( valueType=StageInfo, help="A list of Aegis stages" )

class Batch( DeferredModel ):
   batchId = Int( help="Batch ID number" )
   startBatchTime = Float( optional=True,
                           help="UTC epoch timestamp for batch start time" )
   endBatchTime = Float( optional=True,
                         help="UTC epoch timestamp for batch end time" )
   chips = Dict( keyType=str, valueType=ChipInfo,
                 help="A mapping of chip name to its update stages and status" )

class PlatformStageModel( DeferredModel ):
   batches = List( valueType=Batch,
                   help="A batch of events to update configuration \
                   for a list of chips" )
