# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliGlobal
import CliPlugin.TechSupportCli
import LazyMount

gv = CliGlobal.CliGlobal( dict( hwStatus=None ) )

def _trafficPolicyInterfaceShowTechGuard():
   # We support ingress traffic-policy on Strata through
   # DMF but not through the CLI. So add a guard here for
   # Strata
   if not gv.hwStatus.ingressTrafficPolicyCliSupported:
      return False

   return ( gv.hwStatus.ingressTrafficPolicySupported or
            gv.hwStatus.egressTrafficPolicySupported )

# -------------------------------------------------------------------------------
# Aegis commands in 'show tech-support extended traffic-policy'
# -------------------------------------------------------------------------------

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-04-27 15:42:16',
   cmds=[ 'show platform aegisalgo stage last 3',
          'show platform aegisalgo rules',
          'show platform aegisalgo transforms port',
          'show platform aegisalgo transforms prefix' ],
   cmdsGuard=_trafficPolicyInterfaceShowTechGuard,
   extended='traffic-policy' )

def Plugin( entityManager ):
   gv.hwStatus = LazyMount.mount( entityManager,
                                  'trafficPolicies/hardware/status/interface',
                                  'TrafficPolicy::HwStatus', 'r' )
