# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import AleCountersCli
from CliPlugin import IntfCli
from CliPlugin.IntfCli import countersKw, countersRatesKw
from CliPlugin.AleCountersCli import CliConfigConstants, guardSetIntfFastPollPeriod
import BasicCli
import CliCommand
import CliGlobal
import CliMatcher
import LazyMount

rateWatermarkConfig = None
rateWatermarkSmashTable = None
ethIntfStatusDir = None

watermarkKw = CliMatcher.KeywordMatcher( 'watermark',
                                         helpdesc='maximum rate' )

def rateWatermarkGuard( mode, token ):
   return guardSetIntfFastPollPeriod( mode, token ) and\
      gv.cliCapability.rateWatermarkSupported

# -------------------------------------------------------------------------------
# rate watermark window TIME seconds
# -------------------------------------------------------------------------------
class WatermarkWindowSizeCmd( CliCommand.CliCommandClass ):
   syntax = 'rate watermark window TIME milliseconds'
   noOrDefaultSyntax = 'rate watermark ...'
   data = {
            'rate' : 'Bitrate per intf',
            'watermark' : CliCommand.guardedKeyword(
               'watermark',
               'Maximum bitrate reached during the set window',
               rateWatermarkGuard ),
            'window' : 'Set the window duration to use',
            'TIME' : CliMatcher.IntegerMatcher(
               CliConfigConstants.minRateWatermarkPeriod,
               CliConfigConstants.maxRateWatermarkPeriod,
               helpdesc='Window\'s duration' ),
            'milliseconds' : "Window's duration unit"
          }

   handler = 'AleCountersRateWatermarkCliHandler.rateWatermarkWindowHandler'
   noOrDefaultHandler = \
      'AleCountersRateWatermarkCliHandler.rateWatermarkWindowNoOrDefaultHandler'

AleCountersCli.CounterEthernetConfigMode.addCommandClass( WatermarkWindowSizeCmd )

# -------------------------------------------------------------------------------
# show interfaces counters rates watermark
# -------------------------------------------------------------------------------

class ShowWatermarks( IntfCli.ShowIntfCommand ):
   syntax = 'show interfaces counters rates watermark'
   data = dict( counters=countersKw,
                rates=countersRatesKw,
                watermark=watermarkKw )
   cliModel = "AleCountersRateWatermarkCliModel.InterfaceRateWatermarks"
   handler = "AleCountersRateWatermarkCliHandler.showRateWatermark"

BasicCli.addShowCommandClass( ShowWatermarks )

gv = CliGlobal.CliGlobal(
   cliCapability=None,
   fastWriterConfigDir=None,
   entityManager=None,
   rateWatermarkConfig=None )

def Plugin( em ):
   gv.cliCapability = LazyMount.mount(
      em,
      'counter/global/configcapability',
      'Ale::Counters::CliCapability', 'r' )

   gv.entityManager = em
   gv.fastWriterConfigDir = LazyMount.mount(
      em,
      'counters/fastIntf/writerConfig',
      'Tac::Dir', 'ri' )

   gv.rateWatermarkConfig = LazyMount.mount(
         em,
         'counter/global/rateWatermarkConfig',
         'Ale::Counters::RateWatermarkCliConfig',
         'w' )
