# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliGlobal
import CliParser
import CliToken.Hardware
import CliToken.Ip
import CommonGuards
import ShowCommand
import LazyMount
from CliDynamicSymbol import CliDynamicPlugin
from CliMatcher import (
      KeywordMatcher,
)

ipMatcherForShow = CliToken.Ip.ipMatcherForShow
hardwareMatcherForShow = CliToken.Hardware.hardwareMatcherForShow
aleKwForShow = CliCommand.guardedKeyword( 'ale',
      helpdesc="Ale-specific information",
      guard=CommonGuards.standbyGuard )
AleL3CliModel = CliDynamicPlugin( "AleL3CliModel" )

# --------------------------------------------------------------------------------
# show ip hardware ale mac-address router gateway
# --------------------------------------------------------------------------------
gv = CliGlobal.CliGlobal( dict(
   status=None,
   bridgingHwCapabilities=None,
) )

def evpnMacAliasDefaultGatewaySupportedGuard( mode, token ):
   # when Strata platform support is added, the current implementation
   # should still work because it only looks at the item "l3RouterMacStatusDb"
   # and ignore "l2RouterMacStatusDb"
   if gv.bridgingHwCapabilities.evpnMacAliasDefaultGatewaySupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

class ShowIpHardwareAleRouterMacAddressGatewayCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip hardware ale mac-address router gateway'
   data = { 'ip': ipMatcherForShow,
            'hardware': hardwareMatcherForShow,
            'ale': aleKwForShow,
            'mac-address': 'Display MAC address related information',
            'router': 'Display router MAC addresses',
            'gateway': CliCommand.Node(
                           matcher=KeywordMatcher( "gateway",
                           helpdesc="Gateway MAC address type" ),
                           guard=evpnMacAliasDefaultGatewaySupportedGuard ),
         }
   cliModel = "AleL3CliModel.GatewayMacStatus"
   privileged = True
   handler = "AleGatewayMacCliHandler.doShowIpHardwareAleRouterMacAddressGateway"

BasicCli.addShowCommandClass( ShowIpHardwareAleRouterMacAddressGatewayCmd )

def Plugin( em ):
   gv.status = LazyMount.mount( em, "hardware/ale/routerMacStatusDb",
                                    "Tac::Dir", "ri" )
   gv.bridgingHwCapabilities = LazyMount.mount( em, "bridging/hwcapabilities",
                                    "Bridging::HwCapabilities", "r" )
